//
//  OPSprite.m
//  The Obfuscated Path
//
//  Created by ss2cire on 12/6/08.
//  Copyright 2008 GryphonClaw Software. All rights reserved.
//

#import "OPSprite.h"
#import <OpenGL/gl.h>

#define OP_NO_TEXTURE 0

@implementation OPSprite
- (id)init
{
	return [self initWithLocation:OPMakePoint(0,0) andSize:OPMakeSize(32,32)];
}
- (id)initWithLocation:(OPPoint)inLocation andSize:(OPSize)inSize
{
	self = [super init];  
	if(self != nil)	{
		location = inLocation;
		size = inSize;
		[self setTexture:OP_NO_TEXTURE];
		moveSpeed = (240 * UPDATE_INTERVAL);
		numberOfUpdates = 0;
		visible = YES;
	}
	return self;
}

- (void)setTexture:(GLuint)inTextureID
{
	textureID = inTextureID;
}

- (void)draw
{
	if(visible) {
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, textureID);
	
		glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
		glEnable(GL_BLEND);
	
		glBegin(GL_QUADS);
			glTexCoord2f(0.0, 1.0);
			glVertex2i(location.x, location.y);

			glTexCoord2f(0.0, 0.0);
			glVertex2i(location.x, location.y + size.height);

			glTexCoord2f(1.0, 0.0);
			glVertex2i(location.x + size.width, location.y + size.height);

			glTexCoord2f(1.0, 1.0);
			glVertex2i(location.x + size.width, location.y);
		glEnd();
		glDisable(GL_TEXTURE_2D);
		glDisable(GL_BLEND);
	}
}

- (void)update
{
}

- (void)setLocationX:(int)inX
{
	location.x = inX;
}

- (void)setLocationY:(int)inY
{
	location.y = inY;
}

- (OPPoint)location
{
	return location;
}

- (int)locationX
{
	return location.x;// + (size.width / 2);
}

- (int)locationY
{
	return location.y;// + (size.height / 2);
}

- (OPRect)collisionRect
{
	return NSMakeRect([self locationX], [self locationY], size.width, size.height);
}

- (BOOL)willNotCollide:(OPSprite *)spriteToCheck
{
	return YES;
}

- (void)setVisible:(BOOL)inValue
{
	visible = inValue;
}

- (BOOL)isVisible
{
	return visible;
}
@end
